/*
 * test program for rl01
 * author 
 */

#include <stdio.h>
#include <bsplib.h>
#include <rl01.h>

#define DEBUG_CONSOLE   0

void main(void)
{
    uInt8_t payload = 0x00;
    uInt8_t str_tmp[10];
    uInt8_t i = 0;
    
    /* system init*/
    i2c1_init( I2C1_BAUDRATE );
    rl01_init();
    #if DEBUG_CONSOLE
    uart1_init(UART1_BAUD_RATE);
    #endif
    
    #if DEBUG_CONSOLE
    uart1_puts("RL01 test\n");
    #endif
    
    while ( 1 ) {
        
        /* test de l'criture et de la lecture du buffer du bridge */
        
//        rl01_write( CONFIG_SPI_INTERFACE, 0x02 );
//        rl01_read( &payload );
        
        
        /* test de l'criture et de la lecture du registre RegOpMode */
        
        /* start */
        i2c1_idle();
        i2c1_start();

        /* send address and write sequence */
        i2c1_send( 0x5E );  // address bridge + write
        i2c1_idle();

        /* send data sequence */
        if ( i2c1_ack() )  {
            i2c1_send( 0x0F );  // command SPI write
            i2c1_idle();
        }

        /* send data sequence */
        if ( i2c1_ack() )  {
            i2c1_send( 0x81 );  // write RegOpMode
            i2c1_idle();
        }

        /* send data sequence */
        if ( i2c1_ack() )  {
            i2c1_send( 0x80 );  // LoRa mode
            i2c1_idle();
        }

        /* stop */
        if ( i2c1_ack() )  {
            i2c1_stop();
        }

        delay_1ms();
        
        /* start */
        i2c1_idle();
        i2c1_start();

        /* send address and write sequence */
        i2c1_send( 0x5E );  // address bridge + write
        i2c1_idle();

        /* send data sequence */
        if ( i2c1_ack() )  {
            i2c1_send( 0x0F );  // command SPI write
            i2c1_idle();
        }

        /* send data sequence */
        if ( i2c1_ack() )  {
            i2c1_send( 0x01 );  // read RegOpMode
            i2c1_idle();
        }
        
        for ( i = 0; i < 15; i++ ) {
            /* send data sequence */
            if ( i2c1_ack() )  {
                i2c1_send( 0x00 );
                i2c1_idle();
            }
        }
        
        /* stop */
        if ( i2c1_ack() )  {
            i2c1_stop();
        }
        
        delay_1ms();        
        delay_1ms();
        delay_1ms();        
        delay_1ms();
      
        /* start */
        i2c1_idle();
        i2c1_start();

        /* send address and read sequence */
        i2c1_send( 0x5F );  // address bridge + read
        i2c1_idle();
        
        /* receive data */
        if ( i2c1_ack() ) {
            
            for ( i = 0; i < 15; i++ ) {
                i2c1_receive( payload );
                i2c1_master_ack();
                i2c1_idle();

                #if DEBUG_CONSOLE
                sprintf (str_tmp, "0x%x ", payload);
                uart1_puts(str_tmp); 
                #endif
            }
        
            i2c1_receive( payload );
            i2c1_master_nack();
            i2c1_idle();
            
            #if DEBUG_CONSOLE
            sprintf (str_tmp, "0x%x ", payload);
            uart1_puts(str_tmp); 
            #endif
        }
        
        /* stop */
        i2c1_stop();
        
        #if DEBUG_CONSOLE
        uart1_puts("\r\n");
        #endif

        delay_1ms();
        delay_1ms();
    }
 
}

