/*
* rl01/src/rl01_init.c
* rl01 configuration
*/

#include <i2c1/include/i2c1.h>
#include <rl01.h>

void rl01_init()
{   
    
    /* SC18IS602B */
    
    /* GPIO Enable bit allocation
     * 7    6    5    4    3    2    1    0  
     * X    X    X    X   SS3  SS2  SS1  SS0
     * 1 : enable the pin as a GPIO
     * 0 : disable GPIO control 
     */ 
    i2c1_write( SC18IS602B_ADD, GPIO_ENABLE, 0x00 );  // configure pins as Slave Select
    
    /* Configure SPI Interface bit allocation
     * 7     6     5     4     3     2     1     0  
     * X     X   ORDER   X   MODE1 MODE0   F1    F0
     * ORDER ( data direction ) : 0 -> the MSB is transmitted first
     *                            1 -> the LSB is transmitted first
     * MODE1:MODE0 ( operating mode ) : 00 -> CPOL = 0, CPHA = 0 ( SPICLK low when idle; data clocked in on leading edge )
     * F1:F0 ( frequency )
     */
    i2c1_write( SC18IS602B_ADD, CONFIG_SPI_INTERFACE, 0x03 );

    
    /* RFM */
    
    /* TODO */

}

