/**
 * @file rl01/include/rl01.h
 * @brief header file for rl01 library 
 * @author 
 */

#ifndef RL01_H
#define	RL01_H


/* SC18IS602B */

#define SC18IS602B_ADD   0x2F

/* Commands */
#define CLEAR_INTERRUPT         0xF1
#define IDLE_MODE               0xF2
#define GPIO_ENABLE             0xF6
#define CONFIG_SPI_INTERFACE    0xF0
#define SPI_WRITE               0x0F


/* RFM */

#define RegFifo                 0x00
#define RegOpMode               0x01
#define RegFifoAddrPtr          0x0D  // SPI interface address pointer in FIFO data buffer
#define RegFifoTxBaseAddr       0x0E  // write base address in FIFO data buffer (the point in memory where the transmit information is stored)
#define RegFifoRxBaseAddr       0x0F  // read base address in FIFO data buffer (the point in memory where information will be written)
#define RegFifoRxCurrentAddr    0x10  // start address of last packet received
#define RegRxNbBytes            0x13  // number of payload bytes of latest packet received
#define RegPayloadLength        0x22  // payload length in bytes
#define RegFifoRxByteAddr       0x25  // current value of Rx databuffer pointer (address of last byte written by Lora receiver)

#define FifoTxBaseAddr          0x80
#define FifoRxBaseAddr          0x00



void rl01_init();

uInt8_t rl01_clear_interrupt();

uInt8_t rl01_write( uInt8_t cmd, uInt8_t payload );

uInt8_t rl01_read( uInt8_t *payload );

#endif	/* RL01_H */

