/*
 * test program for cr02
 * author 
 */

#include <stdio.h>
#include <bsplib.h>
#include <htu21d.h>
#include <cr02.h>

#define  DELAY_3S()    for (int i = 0; i < 15; i++) delay_200ms()

#define DEBUG_CONSOLE   1

void main(void)
{     
    uInt16_t temperature;
    uInt16_t humidity;
    uInt8_t checksum;
    
#if DEBUG_CONSOLE
    float humidity_physical_value;
    float temperature_physical_value;
    uInt8_t tmp[50];
#endif
    
    uInt8_t temperature_msb;
    uInt8_t temperature_lsb;
    uInt8_t humidity_msb;
    uInt8_t humidity_lsb;
    
    /* system init */
    i2c1_init( I2C1_BAUDRATE );
#if DEBUG_CONSOLE
    uart1_init( UART1_BAUD_RATE );
#endif
    
    /* soft reset */
    soft_reset( HTU21D_ADD );
    
    /* choice of measurement resolution */
    write_register( HTU21D_ADD, MEASUREMENT_RESOLUTION_11_11 );

    while (1) {
        read_measurement( HTU21D_ADD, TEMPERATURE_MEASUREMENT_HOLD_MASTER, &temperature, &checksum );
        delay_10us();
        read_measurement( HTU21D_ADD, HUMIDITY_MEASUREMENT_HOLD_MASTER, &humidity, &checksum );
        delay_10us();
        
        temperature_msb = (uInt8_t) (temperature >> 8) & 0x00FF;
        temperature_lsb = (uInt8_t) temperature & 0x00FF;
        
        humidity_msb = (uInt8_t) (humidity >> 8) & 0x00FF;
        humidity_lsb = (uInt8_t) humidity & 0x00FF;
        
#if DEBUG_CONSOLE
        humidity &= 0xfffc;
        temperature_physical_value = ( ( temperature * 175.72 ) / 65536 ) - 46.85;
        humidity_physical_value = ( ( humidity * 125.0 ) / 65536 ) - 6;
        
        uart1_puts( "\n~Curiosity~\n\r" );
        uart1_puts( "Sending to cr02_transmitter ...\n\n\r" );
        
        sprintf( tmp, "0x%x%x", temperature_msb, temperature_lsb );
        uart1_puts( tmp );
        sprintf( tmp,
                 " -> Temperature : %d.%02u C",
                 (uInt8_t) temperature_physical_value,
                 (uInt8_t) ((temperature_physical_value - (uInt8_t) temperature_physical_value ) * 100) );
        uart1_puts( tmp );
        uart1_puts( "\n\n\r" );
        
        sprintf( tmp, "0x%x%x", humidity_msb, humidity_lsb );
        uart1_puts( tmp );
        sprintf( tmp,
                 " -> Relative humidity : %d.%02u %%",
                 (uInt8_t) humidity_physical_value,
                 (uInt8_t) ((humidity_physical_value - (uInt8_t) humidity_physical_value ) * 100) );
        uart1_puts( tmp );
        uart1_puts( "\n\n\r" );
#endif
        
        i2c1_write(CR02_ADD, temperature_msb, temperature_lsb);

        DELAY_3S();
                    
        i2c1_write(CR02_ADD, humidity_msb, humidity_lsb);
        
        DELAY_3S();
    }
}

