/*
* htu21d/src/write_register.c
* write user register
*/

#include <i2c1/include/i2c1.h>
#include <htu21d.h>

uInt8_t write_register( uInt8_t add, uInt8_t measurement_resolution )
{   
    /* write register frame :
     *         |                     |             |              |
     * [start] | [address] [w] [ack] | [cmd] [ack] | [data] [ack] | [stop]
     *    1    |     7      1    1   |   8     1   |    8     1   |    1
     */
    
    uInt8_t add_w = 0x00;
    add_w = (uInt8_t) (add << 1);    

    /* start */
    i2c1_idle();
    i2c1_start();
    
    /* send address and write sequence */
    i2c1_send( add_w );
    i2c1_idle();   
 
    /* send command */
    if ( i2c1_ack() ) {
        i2c1_send( WRITE_USER_REGISTER );
        i2c1_idle();
    } else {
        goto fail_add_ack;
    }

    /* send data */
    if ( i2c1_ack() ) {
        i2c1_send( measurement_resolution );
        i2c1_idle();
    } else {
        goto fail_data_ack;
    }
    
    /* stop */
    if ( i2c1_ack() ) {
        i2c1_stop();
    } else {
        goto fail_data_ack;
    }
    
    return TRUE;
fail_add_ack:
fail_data_ack:
    return FALSE;      
}

