/*
* htu21d/src/soft_reset.c
* reboot the htu21d(f) sensor switching the power off and on again
*/

#include <i2c1/include/i2c1.h>
#include <common/include/delay.h>
#include <htu21d.h>

uInt8_t soft_reset( uInt8_t add )
{    
    /* soft reset frame :
     *         |                     |              |
     * [start] | [address] [w] [ack] | [cmd]  [ack] | [stop]
     *    1    |     7      1    1   |   8      1   |    1
     */
    
    uInt8_t add_w = 0x00;
    add_w = (uInt8_t) (add << 1);
    
    delay_40ms();
    
    /* start */
    i2c1_idle();
    i2c1_start();
    
    /* send address and write sequence */
    i2c1_send( add_w );
    i2c1_idle();
    
    /* send command */
    if ( i2c1_ack() ) {
        i2c1_send( SOFT_RESET );
        i2c1_idle();
    } else {
        goto fail_add_ack;
    }
    
    /* stop */
    if ( i2c1_ack() ) {
        i2c1_stop();
    } else {
        goto fail_data_ack;
    }
    
    delay_40ms();
    
    return TRUE;
fail_add_ack:
fail_data_ack:
    return FALSE; 
}

