/*
* htu21d/src/read_register.c
* read user register
*/

#include <i2c1/include/i2c1.h>
#include <common/include/delay.h>
#include <htu21d.h>

uInt8_t read_register( uInt8_t add, uInt8_t *payload )
{   
    /* read register frame :
     *         |                     |             |        |         |                     |
     * [start] | [address] [w] [ack] | [cmd] [ack] | [stop] | [start] | [address] [r] [ack] | [data] [nack] | [stop]
     *    1    |     7      1    1   |   8     1   |    1   |    1    |     7      1    1   |    8     1    |
     */
    
    uInt8_t add_w = 0x00;
    uInt8_t add_r = 0x00;
    
    add_w = (uInt8_t) (add << 1);
    add_r = (uInt8_t) (add << 1);
    add_r |= 0x01;
        
     /* start */
    i2c1_idle();
    i2c1_start();
    
    /* send address and write sequence */
    i2c1_send( add_w );
    i2c1_idle();
    
    /* send command */
    if ( i2c1_ack() ) {
        i2c1_send( READ_USER_REGISTER );
        i2c1_idle();
    } else {
        goto fail_add_ack;
    }
    
    /* stop */
    if ( i2c1_ack() ) {
        i2c1_stop();
    } else {
        goto fail_data_ack;
    }
    
    delay_10us();
    
    /* start */
    i2c1_idle();
    i2c1_start();
    
    /* send address and read sequence */
    i2c1_send( add_r );
    i2c1_idle();
    
    /* receive data */
    if ( i2c1_ack() ) {
        i2c1_receive( *payload );
        i2c1_master_nack();
        i2c1_idle();
    } else {
        goto fail_add_ack;
    }
    
    /* stop */
    i2c1_stop();
    
    return TRUE;
fail_add_ack:
fail_data_ack:
    return FALSE;   
}

