/**
 * @file htu21d/include/htu21d.h
 * @brief header file for htu21d library 
 * @author 
 */

#ifndef HTU21D_H
#define	HTU21D_H

/* Commands */
#define SOFT_RESET                                  0xFE
#define WRITE_USER_REGISTER                         0xE6
#define READ_USER_REGISTER                          0xE7
#define TEMPERATURE_MEASUREMENT_HOLD_MASTER         0xE3
#define HUMIDITY_MEASUREMENT_HOLD_MASTER            0xE5
//#define TEMPERATURE_MEASUREMENT_NO_HOLD_MASTER      0xF3
//#define HUMIDITY_MEASUREMENT_NO_HOLD_MASTER         0xF5
#define MEASUREMENT_RESOLUTION_12_14                0x02    // RH : 12 bits, Temp : 14 bits
#define MEASUREMENT_RESOLUTION_8_12                 0x03    // RH : 8 bits, Temp : 12 bits
#define MEASUREMENT_RESOLUTION_10_13                0x82    // RH : 10 bits, Temp : 13 bits
#define MEASUREMENT_RESOLUTION_11_11                0x83    // RH : 11 bits, Temp : 11 bits

#define HTU21D_ADD        0x40

/**
 * @brief reboot the htu21d(f) sensor switching the power off and on again
 * @param add 7 bits device address
 * @return return TRUE if success else return FALSE 
 */
uInt8_t soft_reset( uInt8_t add );

/**
 * @brief write the resolution of the measurement to the user register
 * @param add 7 bits device address
 * @param measurement_resolution 8 bits payload to send
 * @return return TRUE if success else return FALSE 
 */
uInt8_t write_register( uInt8_t add, uInt8_t measurement_resolution );

/**
 * @brief read the contents of the user register
 * @param add 7 bits device address
 * @param payload pointer to receiving 8 bits data
 * @return return TRUE if success else return FALSE 
 */
uInt8_t read_register( uInt8_t add, uInt8_t *payload );

/**
 * @brief read temperature or relative humidity from sensor and receive the checksum
 * @param add 7 bits device address
 * @param cmd 8 bits command to send
 * @param payload pointer to receiving 16 bits data
 * @param checksum pointer to receiving 8 bits data
 * @return return TRUE if success else return FALSE 
 */
uInt8_t read_measurement( uInt8_t add, uInt8_t cmd, uInt16_t *payload, uInt8_t *checksum );

#endif	/* HTU21DH */

