#include <Wire.h>
#include <RH_RF95.h>

#define LED_BUILTIN 16

#define CR02_FREQUENCY 868.0

#define DEBUG_CONSOLE 1

uint8_t payload_msb;
uint8_t payload_lsb;

/*
  Slave Select mapped to D13/PD2
  Interrupt mapped to D14/PB2
*/
RH_RF95 CR02;

void setup()
{
  pinMode(LED_BUILTIN, OUTPUT);

#if DEBUG_CONSOLE
  Serial.begin(9600, SERIAL_8N1);   // start serial for output
#endif
  
  Wire.begin(4);                    // join i2c bus with address #4
  Wire.onReceive(receiveEvent);     // register event

  if (!CR02.init()) {
#if DEBUG_CONSOLE
    Serial.println("init failed");
#endif
  }

  // The default transmitter power is 13dBm, using PA_BOOST.
  // If you are using RFM95/96/97/98 modules which uses the PA_BOOST transmitter pin, then
  // you can set transmitter powers from 5 to 23 dBm:
  // Failure to do that will result in extremely low transmit powers.

  //CR02.setModemConfig(CR02.Bw31_25Cr48Sf512);
  CR02.setFrequency(CR02_FREQUENCY);
  CR02.setTxPower(23, false);
}

void loop()
{
#if DEBUG_CONSOLE
  Serial.println("\n~cr02_transmitter~");
  Serial.println("Sending to cr02_receiver ...");
  Serial.print("0x");
  Serial.print(payload_msb, HEX);
  Serial.println(payload_lsb, HEX);
#endif

  CR02.send(&payload_msb, sizeof(payload_msb));
  CR02.waitPacketSent();
  CR02.send(&payload_lsb, sizeof(payload_lsb));
  CR02.waitPacketSent();

  delay(3000);
}

// function that executes whenever data is received from master
// this function is registered as an event, see setup()
void receiveEvent(int howMany)
{
  payload_msb = Wire.read();
  payload_lsb = Wire.read();
}
