/*
* i2c1/src/i2c1_write.c
* send 8 bits command and 8 bits data to an I2C slave device
*/

#include <i2c1/include/i2c1.h>

uInt8_t i2c1_write(uInt8_t add, uInt8_t cmd, uInt8_t payload)
{
    uInt8_t add_w = 0x00;

    /* I2C frame :
     *         |                       |              |              |
     * [start] | [address] [r/w] [ack] | [data] [ack] | [data] [ack] | [stop]
     *    1    |    7       1     1    |    8     1   |    8     1   |    1
     */
    add_w = (uInt8_t) (add << 1);
 
    /* start */
    i2c1_idle();
    i2c1_start();
    
    /* send address and write sequence */
    i2c1_send(add_w);
    i2c1_idle();   
 
    /* send data sequence */
    if ( i2c1_ack() )  {
        i2c1_send(cmd);
        i2c1_idle();
    } else {
        goto fail_add_ack;
    }

    /* send data sequence */
    if ( i2c1_ack() )  {
        i2c1_send(payload);
        i2c1_idle();
    } else {
        goto fail_data_ack;
    }
    
    /* stop */
    if ( i2c1_ack() )  {
        i2c1_stop();
    } else {
        goto fail_data_ack;
    }
    
    return TRUE;
fail_add_ack:
fail_data_ack:
    return FALSE;      
}




