/*
* i2c1/src/i2c1_init.c
* i2c1 configuration
*/

#include <i2c1/include/i2c1.h>

void i2c1_init(uInt32_t bdrate)
{
    uInt8_t bdrate_calcul;

    /* pin select
     * MSSP1 SDA/SCL init - datasheet 26.3, 17.1 and 17.2 
     */    
    SSP1DATPPS = 0x14;  // MSSP1 SDA input connected to RC4 pin
    RC4PPS = 0x10;  // MSSP1 SDA output connected to RC4 pin
    SSP1CLKPPS = 0x13;  // MSSP1 SCL input connected to RC3 pin
    RC3PPS = 0x0F;  // MSSP1 SCL output connected to RC3 pin

    ANSELCbits.ANSELC3 = 0; // ST and TTL RC3 input buffer enable
    ANSELCbits.ANSELC4 = 0; // ST and TTL RC3 input buffer enable

    /* baudrate */
    bdrate_calcul = (uInt8_t) ((CPU_FREQ_HZ / (4 * ( (uInt32_t) bdrate))) - 1);           
    SSP1ADD = bdrate_calcul;
    
    /* i2c1 module */
    SSP1STATbits.SMP = 1; // slew rate disable
    SSP1STATbits.CKE = 0; // SMBus disable  
    
    SSP1CON1bits.WCOL = 0; // no colision
    SSP1CON1bits.SSPM = 0b1000; // Master mode
    SSP1CON1bits.SSPEN = 1; // serial port enable
    
    PIR3bits.SSP1IF = 0;
}




