/**
* @file common/include/pic18fx7k40_config.h
* @brief pic18fx7k40 configuration bits 
* @author hugo descoubes - copyleft
*/
#ifndef _DEV_CONFIG_H
#define _DEV_CONFIG_H

/* CONFIG1L */
#pragma config FEXTOSC = OFF    // External Oscillator mode Selection bits->Oscillator not enabled
#pragma config RSTOSC = HFINTOSC_64MHZ    // Power-up default value for COSC bits->HFINTOSC with HFFRQ = 64 MHz and CDIV = 1:1

/* CONFIG1H */
#pragma config CLKOUTEN = OFF    // Clock Out Enable bit->CLKOUT function is disabled
#pragma config CSWEN = ON    // Clock Switch Enable bit->Writing to NOSC and NDIV is allowed
#pragma config FCMEN = ON    // Fail-Safe Clock Monitor Enable bit->Fail-Safe Clock Monitor enabled

/* CONFIG2L */
#pragma config MCLRE = EXTMCLR    // Master Clear Enable bit->If LVP = 0, MCLR pin is MCLR; If LVP = 1, RE3 pin function is MCLR 
#pragma config PWRTE = OFF    // Power-up Timer Enable bit->Power up timer disabled
#pragma config LPBOREN = OFF    // Low-power BOR enable bit->ULPBOR disabled
#pragma config BOREN = SBORDIS    // Brown-out Reset Enable bits->Brown-out Reset enabled , SBOREN bit is ignored

/* CONFIG2H */
#pragma config BORV = VBOR_2P45    // Brown Out Reset Voltage selection bits->Brown-out Reset Voltage (VBOR) set to 2.45V
#pragma config ZCD = OFF    // ZCD Disable bit->ZCD disabled. ZCD can be enabled by setting the ZCDSEN bit of ZCDCON
#pragma config PPS1WAY = OFF    // PPSLOCK bit One-Way Set Enable bit->PPSLOCK bit can be set and cleared repeatedly (subject to the unlock sequence)
#pragma config STVREN = ON    // Stack Full/Underflow Reset Enable bit->Stack full/underflow will cause Reset
#pragma config DEBUG = OFF    // Debugger Enable bit->Background debugger disabled
#pragma config XINST = OFF    // Extended Instruction Set Enable bit->Extended Instruction Set and Indexed Addressing Mode disabled

/* CONFIG3L */
#pragma config WDTCPS = WDTCPS_12    // WDT Period Select bits->Divider ratio 1:131072
#pragma config WDTE = SWDTEN    // WDT operating mode->WDT enabled/disabled by SWDTEN bit

/* CONFIG3H */
#pragma config WDTCWS = WDTCWS_7    // WDT Window Select bits->window always open (100%); software control; keyed access not required
#pragma config WDTCCS = HFINTOSC    // WDT input clock selector->WDT reference clock is the 31.2kHz HFINTOSC output

/* CONFIG4L */
#pragma config WRT0 = OFF    // Write Protection Block 0->Block 0 (000800-003FFFh) not write-protected
#pragma config WRT1 = OFF    // Write Protection Block 1->Block 1 (004000-007FFFh) not write-protected
#pragma config WRT2 = OFF    // Write Protection Block 2->Block 2 (008000-00BFFFh) not write-protected
#pragma config WRT3 = OFF    // Write Protection Block 3->Block 3 (00C000-00FFFFh) not write-protected
#pragma config WRT4 = OFF    // Write Protection Block 3->Block 4 (010000-013FFFh) not write-protected
#pragma config WRT5 = OFF    // Write Protection Block 3->Block 5 (014000-017FFFh) not write-protected
#pragma config WRT6 = OFF    // Write Protection Block 3->Block 6 (018000-01BFFFh) not write-protected
#pragma config WRT7 = OFF    // Write Protection Block 3->Block 7 (01C000-01FFFFh) not write-protected

/* CONFIG4H */
#pragma config WRTC = OFF    // Configuration Register Write Protection bit->Configuration registers (300000-30000Bh) not write-protected
#pragma config WRTB = OFF    // Boot Block Write Protection bit->Boot Block (000000-0007FFh) not write-protected
#pragma config WRTD = OFF    // Data EEPROM Write Protection bit->Data EEPROM not write-protected
#pragma config SCANE = ON    // Scanner Enable bit->Scanner module is available for use, SCANMD bit can control the module
#pragma config LVP = ON    // Low Voltage Programming Enable bit->Low voltage programming enabled. MCLR/VPP pin function is MCLR. MCLRE configuration bit is ignored

/* CONFIG5L */
#pragma config CP = OFF    // UserNVM Program Memory Code Protection bit->UserNVM code protection disabled
#pragma config CPD = OFF    // DataNVM Memory Code Protection bit->DataNVM code protection disabled

/* CONFIG6L */
#pragma config EBTR0 = OFF    // Table Read Protection Block 0->Block 0 (000800-003FFFh) not protected from table reads executed in other blocks
#pragma config EBTR1 = OFF    // Table Read Protection Block 1->Block 1 (004000-007FFFh) not protected from table reads executed in other blocks
#pragma config EBTR2 = OFF    // Table Read Protection Block 2->Block 2 (008000-00BFFFh) not protected from table reads executed in other blocks
#pragma config EBTR3 = OFF    // Table Read Protection Block 3->Block 3 (00C000-00FFFFh) not protected from table reads executed in other blocks
#pragma config EBTR4 = OFF    // Table Read Protection Block 4->Block 4 (010000-013FFFh) not protected from table reads executed in other blocks
#pragma config EBTR5 = OFF    // Table Read Protection Block 5->Block 5 (014000-017FFFh) not protected from table reads executed in other blocks
#pragma config EBTR6 = OFF    // Table Read Protection Block 6->Block 6 (018000-01BFFFh) not protected from table reads executed in other blocks
#pragma config EBTR7 = OFF    // Table Read Protection Block 7->Block 7 (01C000-01FFFFh) not protected from table reads executed in other blocks

/* CONFIG6H */
#pragma config EBTRB = OFF    // Boot Block Table Read Protection bit->Boot Block (000000-0007FFh) not protected from table reads executed in other blocks

#endif /*_DEV_CONFIG_H*/


















