/*
* file adc/src/adc_init.c
* brief internal adc initialization
* author 
*/

#include <adc/include/adc.h>

void adc_init(void)
{
    /* FRC internal ADC clock reference
     * discontinuous mode, left adjust, no interrupt
     * Vref-=Vss and Vref+=VDD, pin RA0/AN0
     * precharge time is exclude from conversion
     * acquisition time is exclude from conversion
     * non aditionnal capacitance
     */
	ADCON0 = 0b00010000;
	ADCON1 = 0x00;
	ADCON2 = 0x00;	
    ADCON3 = 0x00;
    ADREF = 0x00;
    ADPCH = 0x00;       
    ADPRE = 0x00; 
    ADACQ = 0x00; 
    ADCAP = 0x00; 
    
    /* pin selection */
    TRISAbits.TRISA0 = 1;
    ANSELAbits.ANSELA0 = 1;

	adc_enable();
}
