; file common/delay/src/delay_1ms.h
; brief 1ms software delay
; warning 1ms duration only for 64MHz cpu clock  
; author hugo

#include <pic18f27k40.inc>

; linker memory static allocation directives for data
PSECT bss_delay, class=BANK0, space=1
; static privates declarations
delay_cnt1:  ds  1
delay_cnt2:  ds  1
bsr_tmp:     ds  1

; linker memory static allocation directives for code
PSECT text, class=CODE, reloc=2, space=0

global _delay_1ms

_delay_1ms:
    ; save BSR context
    movff   BSR, WREG
    movlb   0
    movff   WREG, bsr_tmp

    ; delay calculation :
    ; Fcpu = 64MHz, Tcpu = 15.625ns
    ; Fcy = Fcpu/4 = 16MHz, Tcy = 62.5ns
    ;
    ; first internal loop :
    ; Tloop1 = (1 + 2) * delay_cnt * Tcy + 2 * Tcy
    ; Tloop1 ~ 3 * delay_cnt * Tcy
    ;
    ; second internal loop :
    ; Tloop2 = (Tloop1 + 5 * Tcy) * delay_cnt2  + (Tloop1 + 4 * Tcy) 
    ; Tloop2 ~ Tloop1 * delay_cnt2
    movlw   100
    movwf   delay_cnt2	

delay_1ms_L1:
    movlw   53
    movwf   delay_cnt1	

delay_1ms_L2:					
    decfsz  delay_cnt1,f		
    bra     $-2
    decfsz  delay_cnt2,f		
    bra     $-10        ; line number offset	    

    ; restore BSR context
    movff    bsr_tmp, BSR 			
    return
END