/**
 * ENSICAEN
 * 6 Boulevard Maréchal Juin
 * F-14050 Caen Cedex
 *
 * This file is owned by ENSICAEN students. No portion of this
 * document may be reproduced, copied or revised without written
 * permission of the authors.
 */

/**
 * @author  Dimitri Boudier <dimitri.boudier@ensicaen.fr>
 * @version 1.0.0 - 2023-09-27
 *
 * @todo	Nothing.
 * @bug		None.
 * @note 	This driver can be used with only ONE Light click at once.
 */

/**
 * @file light_click.c
 * @brief Driver for the MIKROE "Light click" board
 *
 * Ref. https://www.mikroe.com/light-click
 */


#include "main.h"
#include "light_click.h"


/*****************************************************************************
 * GLOBAL VARIABLE DECLARATIONS
 *****************************************************************************/

LIGHT_handle_t light_handle;



/*****************************************************************************
 * FUNCTION DEFINITIONS
 *****************************************************************************/

void LIGHT_init(SPI_HandleTypeDef *hspi, GPIO_TypeDef *SS_Port, uint16_t SS_Pin)
{
    //! @TODO Attach the SPI handle to the Light Click handle
	light_handle.hspi = hspi;

    //! @TODO Attach the SS Port and Pin to the Light Click handle
	light_handle.SS_Port = SS_Port;
	light_handle.SS_Pin  = SS_Pin;
}


void LIGHT_getBrightnessRaw(uint16_t* brightness_raw)
{
    uint8_t reply[2];
    
	//! @TODO Read the brightness value from the Light Click


    /**
	 * See MCP3201 Datasheet, Figure 6-1
	 * |    1st byte (reply[0])   |    2nd byte (reply[1])   |
	 * |--X-X-0-B11-B10-B9-B8-B7--|--B6-B5-B4-B3-B2-B1-B0-X--|
	 */
	//! @TODO Convert the retrieved data into a 12-bit integer
	*brightness_raw  = (uint16_t)(reply[0] & 0x1F) << 7;
	*brightness_raw += (uint16_t)(reply[1]       ) >> 1;
}


void LIGHT_getBrightnessPercentage(float* brightness_percentage)
{
	//! @TODO Read the brightness value
	
	//! @TODO Convert the value into a float and change its scale to [0.0 - 100.0]
}
