/**
 * ENSICAEN
 * 6 Boulevard Maréchal Juin
 * F-14050 Caen Cedex
 *
 * This file is owned by ENSICAEN students. No portion of this
 * document may be reproduced, copied or revised without written
 * permission of the authors.
 */

/**
 * @author  Dimitri Boudier <dimitri.boudier@ensicaen.fr>
 * @version 1.0.0 - 2023-10-14
 *
 * @todo    Nothing.
 * @bug     None.
 * @note    This driver can be used with only ONE Accel 2 click at once.
 */

/**
 * @file accel_2_click.c
 * @brief Driver for the MIKROE "Accel 2 click" board
 *
 * Ref. https://www.mikroe.com/accel-2-click
 */


#include "main.h"
#include "accel_2_click.h"


/*****************************************************************************
 * GLOBAL VARIABLE DECLARATIONS
 *****************************************************************************/

ACCEL_2_handle_t accel_2_handle;



/*****************************************************************************
 * FUNCTION DEFINITIONS
 *****************************************************************************/

void ACCEL_2_init(SPI_HandleTypeDef *hspi, GPIO_TypeDef *SS_Port, uint16_t SS_Pin)
{
	uint8_t value_write, value_read;

	/**
	 * Attach the SPI peripheral handle
	 * Attach the GPIO pin used for the SS signal
	 */
	//! @TODO (1)


	 
	/**
	 * Check if the device is present, 
	 * if not get stuck in an infinite loop.
	 */
	//! @TODO (2)

	 
	/**
	 * Device configuration:
	 * + 4-wire SPI mode
	 * + Acquisition enabled on all three axes
	 * + Continuous data update
	 * + Output data rate > 0 Hz
	 * + Full-scale at +/- 2g
	 * 
	 * Anything else at default value.
	 */
	//! @TODO (3)
	 
}


void ACCEL_2_writeReg(uint8_t reg_addr, uint8_t reg_value)
{
	//! @TODO
}


void ACCEL_2_readReg(uint8_t reg_addr, uint8_t* reg_value, uint8_t n_bytes)
{
	//! @TODO
}


void ACCEL_2_getSensitivity(float* sensitivity)
{
	uint8_t ctrl_reg5_value;
	
	*sensitivity = ACCEL_2_SENSITIVITY_AT_2G;
	
	//! @TODO
}


void ACCEL_2_getAccelX(float* x_accel)
{
	uint8_t out_x_registers[2];
	int16_t out_x_value;
	float x_raw_value;
	float sensitivity;

	ACCEL_2_readReg(ACCEL_2_REG_OUT_X_L, out_x_registers, sizeof(out_x_registers));
	out_x_value = (int16_t)( (out_x_registers[1] << 8) + out_x_registers[0] );
	x_raw_value = (float)(out_x_value);

	ACCEL_2_getSensitivity(&sensitivity);

	*x_accel = sensitivity * x_raw_value;
}


void ACCEL_2_getAccelY(float* y_accel)
{
	uint8_t out_y_registers[2];
	int16_t out_y_value;
	float y_raw_value;
	float sensitivity;

	ACCEL_2_readReg(ACCEL_2_REG_OUT_Y_L, out_y_registers, sizeof(out_y_registers));
	out_y_value = (int16_t)( (out_y_registers[1] << 8) + out_y_registers[0] );
	y_raw_value = (float)(out_y_value);

	ACCEL_2_getSensitivity(&sensitivity);

	*y_accel = sensitivity * y_raw_value;
}


void ACCEL_2_getAccelZ(float* z_accel)
{
	uint8_t out_z_registers[2];
	int16_t out_z_value;
	float z_raw_value;
	float sensitivity;

	ACCEL_2_readReg(ACCEL_2_REG_OUT_Z_L, out_z_registers, sizeof(out_z_registers));
	out_z_value = (int16_t)( (out_z_registers[1] << 8) + out_z_registers[0] );
	z_raw_value = (float)(out_z_value);

	ACCEL_2_getSensitivity(&sensitivity);

	*z_accel = sensitivity * z_raw_value;
}


void ACCEL_2_getAccelXYZ(float* x_accel, float* y_accel, float* z_accel)
{
	uint8_t out_xyz_registers[6];
	int16_t out_x_value;
	int16_t out_y_value;
	int16_t out_z_value;
	float x_raw_value;
	float y_raw_value;
	float z_raw_value;
	float sensitivity;

	ACCEL_2_readReg(ACCEL_2_REG_OUT_X_L, out_xyz_registers, sizeof(out_xyz_registers));
	out_x_value = (int16_t)( (out_xyz_registers[1] << 8) + out_xyz_registers[0] );
	out_y_value = (int16_t)( (out_xyz_registers[3] << 8) + out_xyz_registers[2] );
	out_z_value = (int16_t)( (out_xyz_registers[5] << 8) + out_xyz_registers[4] );
	x_raw_value = (float)(out_x_value);
	y_raw_value = (float)(out_y_value);
	z_raw_value = (float)(out_z_value);

	ACCEL_2_getSensitivity(&sensitivity);

	*x_accel = sensitivity * x_raw_value;
	*y_accel = sensitivity * y_raw_value;
	*z_accel = sensitivity * z_raw_value;
}

