/**
 * ENSICAEN
 * 6 Boulevard Maréchal Juin
 * F-14050 Caen Cedex
 *
 * This file is owned by ENSICAEN students. No portion of this
 * document may be reproduced, copied or revised without written
 * permission of the authors.
 */

/**
 * @author  Dimitri Boudier <dimitri.boudier@ensicaen.fr>
 * @version 1.0.0 - 2023-09-27
 *
 * @todo	Nothing.
 * @bug		None.
 * @note 	This driver can be used with only ONE Light click at once.
 */

/**
 * @file light_click.h
 * @brief Driver for the MIKROE "Light click" board
 *
 * Ref. https://www.mikroe.com/light-click
 */


#ifndef INC_LIGHT_CLICK_H_
#define INC_LIGHT_CLICK_H_



/*****************************************************************************
 * STRUCTURE DECLARATIONS
 *****************************************************************************/

/**
 * Handle to an initialized Light click.
 *
 * This handle contains the handle to the SPI peripheral to use,
 * and the Slave Select GPIO.
 */
typedef struct {
	SPI_HandleTypeDef *hspi;	//!< SPI peripheral handle
	GPIO_TypeDef* SS_Port;		//!< Slave Select pin port
	uint16_t SS_Pin;			//!< Slave Select pin number
}LIGHT_handle_t;



/*****************************************************************************
 * FUNCTION DECLARATIONS
 *****************************************************************************/

/**
 * Initialization function of the light click board.
 *
 * @param[in]	hspi		the handle to the STM32 SPI peripheral
 * @param[in]	SS_Port		the port of the Slave Select (or Chip Select) pin
 * @param[in]	SS_Pin		the pin number of the Slave Select (or Chip Select) pin
 *
 * Sets the LIGHT_handle_t with the given parameters, including: (1) the SPI
 * peripheral handle (i.e. SCK and MISO pins), (2) the SS GPIO port and pin.
 * This init function does not actually communicate with the Light Click.
 *
 * If using a MIKROE Arduino UNO Click Shield on a NUCLEO-WL55JC1 board:
 * - Slot 1, SS is on D10/PA4
 * - Slot 2, SS is on D9 /PA9
 * If using a MIKROE Arduino UNO Click Shield on a NUCLEO-L073RZ or NUCLEO-L476RG board:
 * - Slot 1, SS is on D10/PB6
 * - Slot 2, SS is on D9 /PC7
 */
void LIGHT_init(SPI_HandleTypeDef *hspi, GPIO_TypeDef *SS_Port, uint16_t SS_Pin);


/**
 * Gives the brightness value in a 12-bit integer format.
 *
 * @param[out]	brightness_raw 	pointer to the brightness value [0-4095]
 */
void LIGHT_getBrightnessRaw(uint16_t* brightness_raw);


/**
 * Gives the brightness value in percentage.
 *
 * @param[out]	brightness_percentage 	pointer to the brightness value [0.0-100.0]
 */
void LIGHT_getBrightnessPercentage(float* brightness_percentage);


#endif /* INC_LIGHT_CLICK_H_ */
