/*
* file test/src/test_sys.c
* brief system/conformity test for output vectors of miscellaneous algorithms
* author hugo descoubes
* date mixing 09/2012 and 09/2021
*/

#include <test.h>


Boolean test_sys(	TestSystem_obj *conformity,
						float *src1,
						float *src2,
						uint64_t size) {
	volatile int i;
	volatile float diff, diff_percent, max_percent=0.0f, errorMax;
	volatile uint64_t nbError=0;
	
	errorMax = conformity->error_margin;

	/* conformity or validity test procedure */
	for (i=0; i<size-1; i++) {

		diff = (float32_t) fabs ( (double) (src1[i] - src2[i]));

		if (isnan(diff)) {
			diff_percent = 100.0f;

		} else if (isinf(diff)) {
			diff_percent = 100.0f;

		} else {
			diff_percent = (diff * 100.0f) / src1[i];
		}

		if (diff_percent > max_percent)
			max_percent = diff_percent;

		if (diff_percent > errorMax) {
			nbError++;
		}
	}

	/* back up measurements */
	conformity->error_percent = max_percent;
	conformity->error_samples = nbError;
	if (conformity->error_samples != 0) {
		strcpy(conformity->error_status, "NOK");
		return FALSE;
	} else {
		strcpy(conformity->error_status, "OK");
		return TRUE;
	}
}

