/****************************************************************************/
/*  C6678_unified.cmd                                                       */
/*  Copyright (c) 2011 Texas Instruments Incorporated                       */
/*													                                     						*/
/*    Description: This file is a sample linker command file that can be    */
/*                 used for linking programs built with the C compiler and  */
/*                 running the resulting .out file on an C6678              */
/*                 device.  Use it as a guideline.  You will want to        */
/*                 change the memory layout to match your specific C6xxx    */
/*                 target system.  You may want to change the allocation    */
/*                 scheme according to the size of your program.            */
/*                                                                          */
/****************************************************************************/

-stack 0x2000
-heap 0x8000

MEMORY
{
  LOCAL_L2_SRAM:  origin = 0x00800000 length = 0x00080000   /* 512kB LOCAL L2/SRAM */
  LOCAL_L1P_SRAM: origin = 0x00E00000 length = 0x00008000   /* 32kB LOCAL L1P/SRAM */
  LOCAL_L1D_SRAM: origin = 0x00F00000 length = 0x00008000   /* 32kB LOCAL L1D/SRAM */
  MSMCSRAM:       origin = 0x0C000000 length = 0x00400000   /* 4MB Multicore shared Memmory */
  
  EMIF16_CS2:     origin = 0x70000000 length = 0x04000000   /* 64MB EMIF16 CS2 Data Memory */
  EMIF16_CS3:     origin = 0x74000000 length = 0x04000000   /* 64MB EMIF16 CS3 Data Memory */
  EMIF16_CS4:     origin = 0x78000000 length = 0x04000000   /* 64MB EMIF16 CS4 Data Memory */
  EMIF16_CS5:     origin = 0x7C000000 length = 0x04000000   /* 64MB EMIF16 CS5 Data Memory */

  DDR3:           origin = 0x80000000 length = 0x20000000   /* 512MB external DDR3 SDRAM - TMDSEVM6678L board specific */
}
 
SECTIONS
{
	.text          >  MSMCSRAM
	.stack         >  MSMCSRAM
	.bss           >  MSMCSRAM
	.cio           >  MSMCSRAM
	.const         >  MSMCSRAM
	.data          >  MSMCSRAM
	.switch        >  MSMCSRAM
	.sysmem        >  MSMCSRAM
	.far           >  MSMCSRAM
    .args          >  MSMCSRAM
	.ppinfo        >  MSMCSRAM
	.ppdata        >  MSMCSRAM

  /* COFF sections */
	.pinit         >  MSMCSRAM
	.cinit         >  MSMCSRAM

  /* EABI sections */
    .binit         >  MSMCSRAM
	.init_array    >  MSMCSRAM
    .neardata      >  MSMCSRAM
	.fardata       >  MSMCSRAM
	.rodata        >  MSMCSRAM
	.c6xabi.exidx  >  MSMCSRAM
	.c6xabi.extab  >  MSMCSRAM

  /* project specific */
}
