/*
* file test/src/test_perf.c
* brief performance test for FIR algorithms library
* author hugo descoubes
* date mixing 09/2012 and 09/2021
*/


#include <test.h>


void test_perf(	TestPerf_obj *benchmark,
					uint8_t memoryModel,
					float * restrict output,
					void (*eval_fct) (	const float * restrict,
										const float * restrict,
										float * restrict,
										int) )
{
	volatile CSL_Uint64 start, end, duration=0;
	volatile uint32_t k, rep;

	for (k=0; k < ARRAY_LENGTH; k++) {
		output[k] = 0.0;
	}

	rep = benchmark->perf_rep;

	/* fix number of algorithm repetitions for average calculation */
	for (k=0; k < rep; k++) {

		/* read current TSC core timer value */
		start = CSL_tscRead ();

		/* indirect call of the needed fir algorithm */
		(*eval_fct) (src1_sp, src2_sp, output, ARRAY_LENGTH);

		/* processing time duration */
		end = CSL_tscRead ();
		duration += end-start;
	}

	/* back up measurements */
	duration /= benchmark->perf_rep;
	benchmark->perf_nbcycles = duration;
	benchmark->perf_usertime_ms = (float32_t) duration * CPU_CLOCK_MS;
	benchmark->perf_macs = ((float32_t) EVAL_NB_MACS) / ((float32_t) duration);
}

