/**
 * ENSICAEN
 * 6 Boulevard Marchal Juin
 * F-14050 Caen Cedex
 *
 * This file is owned by ENSICAEN students. No portion of this
 * document may be reproduced, copied or revised without written
 * permission of the authors.
 */

/**
 * @author  Dimitri Boudier <dimitri.boudier@ensicaen.fr>
 * @version 1.0.q9 - 2024-04-22
 *
 * @note 	This file exists in 8 different version, one for each training question
 */

/**
 * @file    main.c
 * @brief   Correction of the training lab exam
 */

#include <bsplib.h>
#include <stdio.h>      // Question 9 (sprintf)

/** Global variables */
uInt8_t     minuteur_actif = FALSE;
uInt16_t    valeur_initiale_minuteur = 5;
uInt16_t    valeur_courante_minuteur;


/** High-priority Interrupt Service Routine */
void __interrupt(high_priority) isr_high (void)
{ 
    /** @todo */
    // Question 8
    uart1_isr_process();
}


/** Low-priority Interrupt Service Routine */
void __interrupt(low_priority) isr_low (void)
{
    /** @todo */
    // Question 3
    if( PIR0 & 0x20 )
    {
        PIR0 &= ~0x20;
        timer0_reload( 15625 );
        led2_toggle();
        
        // Question 5
        if( minuteur_actif )
        {
            valeur_courante_minuteur--;
            
            // Question 6
//            uart1_puts("\r\n");
//            uart1_putc(valeur_courante_minuteur + '0');
//            uart1_puts(" s");
            
            // Question 9
            uInt8_t nombre_en_texte[10];
            sprintf(nombre_en_texte, "\r\n%d s", valeur_courante_minuteur);
            uart1_puts(nombre_en_texte);
            
            // Question 5
            if( valeur_courante_minuteur == 0 )
            {
                led3_off();
                uart1_puts("\r\nTemps ecoule");
                minuteur_actif = FALSE;
            }
        }
    }
}


/** main function */
void main(void)
{    
    /* system initialization */
    // Question 8
    uInt8_t caractere_recu;
    
    // Question 9
    uInt8_t les_caracteres[5];
    
    // Question 2
    uart1_init( 115200 );
    uart1_puts( "\r\n\r\n### DEMARRAGE DE L'APPPLICATION MINUTEUR" );
    
    // Question 3
    led2_init();
    led3_init();
    led4_init();
    led5_init();
    led2_off();
    led3_off();
    led4_off();
    led5_off();
    
    timer0_init( 15625 );   // Attention, la valeur dpend du prescaler choisi (ici 1:1024)
    
    INTCON |= 0xE0;
    
    // Question 4
    switch1_init();
    
    // Question 7
    switch2_init();

    /* application's main loop */
    while (1)
    {
        // Question 4
        if( switch1_read() )
        {
            while( switch1_read() );        // On reste bloqu tant que le bouton est appuy
            led3_on();
            uart1_puts( "\r\nTop minuteur" );
            
            // Question 5
            valeur_courante_minuteur = valeur_initiale_minuteur;
            minuteur_actif = TRUE;
        }
        
        // Question 7
        if( switch2_read() )
        {
            while( switch2_read() );        // On reste bloqu tant que le bouton est appuy
            minuteur_actif ^= TRUE;
        }
        
        // Question 8
//        if( uart1_getc(&caractere_recu, UART1_ECHO) == TRUE )
//        {
//            uart1_puts("\r\n");
//            if( (caractere_recu >= '0') && (caractere_recu <= '9') )
//            {
//                valeur_initiale_minuteur = caractere_recu - '0';
//            }
//        }
        
        // Question 9
        if( uart1_gets( les_caracteres, 5, UART1_ECHO ) == TRUE )
        {
            uart1_puts(les_caracteres);
            uInt8_t i = 0;
            uInt8_t nombre_est_valide = TRUE;
            do{
                if( (les_caracteres[i] < '0') || (les_caracteres[i] > '9') )
                {
                    nombre_est_valide = FALSE;
                }
                i++;
            }while( les_caracteres[i] != '\0' );
            
            if( nombre_est_valide )
            {
                i = 0;
                valeur_initiale_minuteur = 0;
                do{
                    valeur_initiale_minuteur *= 10;
                    valeur_initiale_minuteur += (les_caracteres[i] - '0');
                    i++;
                }while( les_caracteres[i] != '\0' );
            }
            
        }
    }       
}
