/**
 * ENSICAEN
 * 6 Boulevard Marchal Juin
 * F-14050 Caen Cedex
 *
 * This file is owned by ENSICAEN students. No portion of this
 * document may be reproduced, copied or revised without written
 * permission of the authors.
 */

/**
 * @author  Dimitri Boudier <dimitri.boudier@ensicaen.fr>
 * @version 1.0.q6 - 2024-04-22
 *
 * @note 	This file exists in 8 different version, one for each training question
 */

/**
 * @file    main.c
 * @brief   Correction of the training lab exam
 */

#include <bsplib.h>


/** Global variables */
uInt8_t     minuteur_actif = FALSE;
uInt16_t    valeur_initiale_minuteur = 5;
uInt16_t    valeur_courante_minuteur;


/** High-priority Interrupt Service Routine */
void __interrupt(high_priority) isr_high (void)
{ 
    /** @todo */
}


/** Low-priority Interrupt Service Routine */
void __interrupt(low_priority) isr_low (void)
{
    /** @todo */
    // Question 3
    if( PIR0 & 0x20 )
    {
        PIR0 &= ~0x20;
        timer0_reload( 15625 );
        led2_toggle();
        
        // Question 5
        if( minuteur_actif )
        {
            valeur_courante_minuteur--;
            
            // Question 6
            uart1_puts("\r\n");
            uart1_putc(valeur_courante_minuteur + '0');
            uart1_puts(" s");
            
            // Question 5
            if( valeur_courante_minuteur == 0 )
            {
                led3_off();
                uart1_puts("\r\nTemps ecoule");
                minuteur_actif = FALSE;
            }
        }
    }
}


/** main function */
void main(void)
{    
    /* system initialization */
    
    // Question 2
    uart1_init( 115200 );
    uart1_puts( "\r\n\r\n### DEMARRAGE DE L'APPPLICATION MINUTEUR" );
    
    // Question 3
    led2_init();
    led3_init();
    led4_init();
    led5_init();
    led2_off();
    led3_off();
    led4_off();
    led5_off();
    
    timer0_init( 15625 );   // Attention, la valeur dpend du prescaler choisi (ici 1:1024)
    
    INTCON |= 0xE0;
    
    // Question 4
    switch1_init();

    /* application's main loop */
    while (1)
    {
        // Question 4
        if( switch1_read() )
        {
            while( switch1_read() );        // On reste bloqu tant que le bouton est appuy
            led3_on();
            uart1_puts( "\r\nTop minuteur" );
            
            // Question 5
            valeur_courante_minuteur = valeur_initiale_minuteur;
            minuteur_actif = TRUE;
        }
    }       
}
