/*
 * Header file which doxygen parses to generate the main documentation page
 */

 /**
 * @mainpage BSPLIB v1.0 - API Reference 
 *  This is the main landing page for the BSPLIB API Reference. You can navigate by 
 *  functional category using the links provided below. You can always return to this page 
 *  via the "Main Page" tab above.
 *
 * @section introduction Introduction
 *  The ENSICAEN BSPLIB is a Board Support Package function Library for C programmers. 
 *  This library can be directly used with curiosity HPC board with following specifications.
 *
 * @section tools Software et hardware tools
 * 
 * @li Board : Microchip Curiosity HPC Rev 1
 * @li MCU Chip : Microchip PIC18F27K40
 * @li IDE : Microchip MPLAB X v4.15 and later
 * @li Toolchain : Microchip XC8 v1.45
 * @li Click board : Mikroelektronika USB UART click and BT Audio click (RN52)
 *
 * @section modules Modules
 *
 *  - @ref DELAY
 *  - @ref GPIO
 *  - @ref TIMER
 *  - @ref ADC
 *  - @ref I2C
 *  - @ref LCD
 *  - @ref UART
 *  - @ref BLUETOOTH
 */  

 /** @defgroup  DELAY DELAY - Software Delays     							*/
 /** @defgroup  TIMER TIMER - Internal Counters   							*/
 /** @defgroup  GPIO GPIO - Switch and LED									*/
 /** @defgroup  ADC ADC - Analog to Digital Converters     					*/
 /** @defgroup  I2C I2C - Inter-Integrate Circuit  	 						*/
 /** @defgroup  LCD LCD - Liquid Cristal Display    						*/
 /** @defgroup  UART UART - Universal Asynchronous Receiver Transmitter 	*/
 /** @defgroup  BLUETOOTH BLUETOOTH - Bluetooth modules 					*/
