; file common/delay/src/delay_10us.h
; brief 10us software delay
; warning 10us duration only for 64MHz cpu clock  
; author hugo

#include <pic18f27k40.inc>

; linker memory static allocation directives for data
PSECT bss_delay,class=BANK0,space=1
; static privates declarations
delay_cnt1:  ds 1   ; 1 byte static memory allocation
bsr_tmp:     ds  1

; linker memory static allocation directives for code
PSECT text, class=CODE, reloc=2, space=0

global _delay_10us

_delay_10us:
    ; save BSR context
	movff   BSR, WREG
    movlb   0
    movff   WREG, bsr_tmp

    movlw   53
    movwf   delay_cnt1	

    ; delay calculation :
    ; Fcpu = 64MHz, Tcpu = 15.625ns
    ; Fcy = Fcpu/4 = 16MHz, Tcy = 62.5ns
    ;
    ; first internal loop :
    ; Tloop1 = (1 + 2) * delay_cnt1 * Tcy + 3 * Tcy
    ; Tloop1 ~ 3 * delay_cnt1 * Tcy

delay_10us_L1:					
    decfsz  delay_cnt1,f		
    goto    delay_10us_L1	

    ; restore BSR context
    movff    bsr_tmp, BSR		     			
    return
END