/*
* bluewave - bluetooth speaker application
* author 
*/

#include <bluewave.h>

static uInt8_t scheduler_tick;

void __interrupt(low_priority) isr_low (void)
{
    uart1_isr_process ();  
    uart2_isr_process ();    				
}

void __interrupt(high_priority) isr_high (void)
{ 
    if( PIR0bits.TMR0IF )	{
        PIR0bits.TMR0IF = 0;
        timer0_reload(TIMER0_PERIOD);
        led5_on();
        scheduler_tick = 1;
    }						
}

void main(void)
{ 
    bluewave_env speaker;

    system_init(); 
    app_init(&speaker);
    
    while (1) {
        if (scheduler_tick){
            scheduler_tick = 0;
            app_scheduler(&speaker);        
        }
        led5_off();
        sleep();
    }      
}
