/*
* bluewave - bluetooth speaker application library
* author 
*/

#include <bluewave.h>

void system_init(void) 
{
    adc_init();
    led2_init();
    led3_init();
    led4_init();
    led5_init();
    switch1_init();
    switch2_init();
    uart1_init(9600);
    timer0_init(SYSTEM_TICK_PERIOD);
//    lcd_init(); 
    sys_interrupt_enable(); /* need for RN52 init by UART */
    if (!rn52_init())
        reset();
}


void app_init(bluewave_env *speaker)
{
    speaker->state          = TASK_INPUTS;
    
    speaker->vol_plus       = FALSE;
    speaker->vol_plus_flag  = FALSE;
    
    speaker->vol_minus      = FALSE;
    speaker->vol_minus_flag = FALSE;
    
    speaker->playpause      = FALSE;
    speaker->playpause_flag = FALSE;
}


/*
 * OFFLINE SCHEDULER WORKFLOW
 * 
 *        major cycle = 60ms
 *  <------------------------------>
 * 
 *  minor cycle
 *  tick = 20ms
 *  <-------->            
 * |----------|----------|----------|
 * |          |          |          |
 * |task      |task      |task      |
 * |inputs    |display   |bluetooth | <- task name
 * |<15us     |<13ms     |<16ms     | <- max duration time
 */
void app_scheduler(bluewave_env *speaker)
{    
    /* scheduling engine */
    switch(speaker->state)
    {
        case TASK_INPUTS:
            led2_on();
            task_inputs(speaker);
            led2_off();
            break;
        case TASK_DISPLAY:
            led3_on();
            task_display(speaker);
            led3_off();
            break;
        case TASK_BLUETOOTH:
            led4_on();
            task_bluetooth(speaker);
            led4_off();
            break;
    }
    
    speaker->state++; 
    if (speaker->state > TASK_BLUETOOTH ) 
    {
        speaker->state = TASK_INPUTS;
    }
}
