/*
 * rn52/src/rn52_init.c
 * RN52 bluetooth module default configuration
 * author 
 */

#include <rn52/include/rn52.h>

uInt8_t rn52_init(void)
{
    uInt8_t rn52_ack[10], lost;
 
    /* reset and power enable sequence */
    TRISBbits.TRISB1 = 0;   // RST pin
    TRISBbits.TRISB2 = 0;   // PWR_EN pin
    LATBbits.LATB1 = 1;
    LATBbits.LATB2 = 0;
    delay_200ms();
    LATBbits.LATB1 = 0;    
    LATBbits.LATB2 = 1;   
    
    uart2_init(UART2_BAUD_RATE);
    sys_interrupt_enable();  
  
    /* waiting for RN52 command mode activation
     *   'C'   'M'   'D'   '\r'    '\n'
     * <-------- gets --------> <- getc ->
     */
    while (!uart2_gets(rn52_ack, 10, UART2_ECHO_OFF)); 
    while (!uart2_getc(&lost, UART2_ECHO_OFF)); 
    
    if (strcmp(rn52_ack, "CMD"))
        goto fail_activation;
    
    /* default application configuration */
    if (!rn52_cmd(RN52_DEV_NAME))
        goto fail_cmd_ack;

    if (!rn52_cmd(RN52_A2DP_PROFILE))
        goto fail_cmd_ack;
    
    if (!rn52_cmd(RN52_NO_CODE))
        goto fail_cmd_ack;

//    if (!rn52_cmd(RN52_RECONNECT))
//        goto fail_cmd_ack;    
           
    return TRUE;
fail_activation:
fail_cmd_ack:
    return FALSE;  
}