/*
 * rn52/src/rn52_cmd.c
 * send command to RN52 bluetooth module
 * author 
 */

#include <rn52/include/rn52.h>

uInt8_t rn52_cmd(const uInt8_t *cmd)
{
    uInt8_t rn52_ack[10], lost;
  
    uart2_puts(cmd);
    uart2_putc('\r');
    #ifdef CONFIG_UART1_CONSOLE
    uart1_puts(cmd);   
    uart1_puts("\n\r");
    #endif  /* #ifdef CONFIG_UART1_CONSOLE */  
    
    /* waiting for RN52 command acknowledgment
     *   'A'   'O'   'K'   '\r'    '\n'
     * <-------- gets --------> <- getc ->
     */
    while (!uart2_gets(rn52_ack, 10, UART2_ECHO_OFF)); 
    while (!uart2_getc(&lost, UART2_ECHO_OFF)); 
    #ifdef CONFIG_UART1_CONSOLE
    uart1_puts(rn52_ack);   
    uart1_puts("\n\r");
    #endif  /* #ifdef CONFIG_UART1_CONSOLE */
        
    if (strcmp(rn52_ack, "AOK"))
        return FALSE;
    else
        return TRUE;
}