/*
 * test program for RN52 bluetooth module library
 * author 
 */

#include <bsplib.h>

#define APP_BUFFER_SIZE 77

void __interrupt(high_priority) isr_high (void)
{ 
    /* high ISR processing */					
}


void __interrupt(low_priority) isr_low (void)
{
    uart1_isr_process ();  
    uart2_isr_process ();    				
}

void main(void)
{
    uInt8_t tmp, str_tmp[APP_BUFFER_SIZE];
     
    /* system init*/
    if (!rn52_init())
        reset();
    
    /* bridge application */ 
    while (1) {
        if (uart1_gets(str_tmp, APP_BUFFER_SIZE, UART1_ECHO)) {
            uart2_puts(str_tmp);
            uart2_putc('\n');
            while (!uart2_gets(str_tmp, APP_BUFFER_SIZE, UART1_ECHO_OFF)); 
            while (!uart2_getc(&tmp, UART1_ECHO_OFF));
            uart1_puts("\n\r");
            uart1_puts(str_tmp);   
            uart1_puts("\n\r");
        }         
    }      
}
