/*
 * lcd/src/lcd_init.c
 * lcd controller configuration
 * author 
 */

#include <lcd/include/lcd.h>

void lcd_init(void)
{
    i2c1_init(LCD_I2C_BAUDRATE);
    
    /* initialization sequence */
    delay_40ms();    
    lcd_cmd(0b00111000);    // Function set : 
                            // DL = 1(8 bit), N = 1(2 lines)
                            // DH = 0(normal font), IS = 0
    delay_10us();
    delay_10us();
    delay_10us();
    delay_10us();
    delay_10us();
    lcd_cmd(0b00111001);    // Function set : 
                            // DL = 1, N = 1, DH = 0, IS = 1 
    delay_10us();
    delay_10us();
    delay_10us();
    delay_10us();
    delay_10us();
    lcd_cmd(0b00010100);    // Internal OSC frequency : 
                            // BS = 0(1/5 bias), F2 = 1, F1 = 0, F0 = 0
    delay_10us();
    delay_10us();
    delay_10us();
    delay_10us();
    delay_10us();
    lcd_cmd(0b01110100);    // Contrast set : 
                            // C3 = 0, C2 = 1, C1 = 0, C0 = 0 
    delay_10us();
    delay_10us();
    delay_10us();
    delay_10us();
    delay_10us();
    lcd_cmd(0b01010100);    // Power/ICON control/ Contrast set : 
                            // Ion = 0, Bon = 1, C5 = 0, C4 = 0
    delay_10us();
    delay_10us();
    delay_10us();
    delay_10us();
    delay_10us();
    lcd_cmd(0b01101111);    // Follower control :
                            // Fon = 1, Rab2 = 1, Rab1 = 1, Rab0 = 1
    delay_10us();
    delay_10us();
    delay_10us();
    delay_10us();
    delay_10us();
    lcd_cmd(0b00111000);    // Function set : 
                            // DL = 1(8 bit), N = 1(2 lines)
                            // DH = 0(normal font), IS = 0                     
    delay_200ms();
	
    /* pre-configuration sequence */
    lcd_cmd(0b00001100);    // Display ON/OFF control:  
                            // D = 1(display on)
                            // C = 0(cursor off), B = 0 (blink off)
    lcd_cmd(0b00000001);    // Clear display
    lcd_cmd(0b00000010);    // return home 
    delay_10us();
    delay_10us();
    delay_10us();
    delay_10us();
    delay_10us();
}