/*
* lcd/src/lcd_driver.c
* I2C driver for ST7032I LCD controller
* author 
*/

#include <lcd/include/lcd.h>

void lcd_driver(uInt8_t add, uInt8_t cmd_or_data, uInt8_t payload)
{
    i2c1_write(add, cmd_or_data, payload);
    
    /* ST7032I display controller processing time
     * command : wait more than 1.08ms
     * data : wait more than 26.3us
     */
    if (cmd_or_data == DATA){
        delay_10us();
        delay_10us();
        delay_10us();
        delay_10us();
        delay_10us();
    } else {
        delay_1ms();
        delay_1ms();
    }      
}



