/*
* file lcd/src/lcd_createPattern.c
* brief send custom patterns to display controller in CGRAM
* author 
*/

#include <lcd/include/lcd.h>

/*
 * send custom patterns to display controller in CGRAM
 */
void lcd_createPatterns(CustomPatterns *customsChar)
{
     uInt8_t i;
  
    /* writing in CGRAM to the first location.  
     * Controller will automatically  increment to next location. 
     */
    lcd_cmd(0x40);

    /* send all patterns to CGRAM */
    for (i = 0; i < DIGIT_PIXEL_LINE_NB; i++) {
        lcd_char(customsChar->pattern0[i]);
    }

    for (i = 0; i < DIGIT_PIXEL_LINE_NB; i++) {
        lcd_char(customsChar->pattern1[i]);
    }
    
    for (i = 0; i < DIGIT_PIXEL_LINE_NB; i++) {
        lcd_char(customsChar->pattern2[i]);
    }

    for (i = 0; i < DIGIT_PIXEL_LINE_NB; i++) {
        lcd_char(customsChar->pattern3[i]);
    }

    for (i = 0; i < DIGIT_PIXEL_LINE_NB; i++) {
        lcd_char(customsChar->pattern4[i]);
    }  

    for (i = 0; i < DIGIT_PIXEL_LINE_NB; i++) {
        lcd_char(customsChar->pattern5[i]);
    }

    for (i = 0; i < DIGIT_PIXEL_LINE_NB; i++) {
        lcd_char(customsChar->pattern6[i]);
    }

    for (i = 0; i < DIGIT_PIXEL_LINE_NB; i++) {
        lcd_char(customsChar->pattern7[i]);
    }

    /* set DDRAM address */
    lcd_cmd(0x80);   
}