/**
* @file common/include/common.h
* @brief generic header file for BSP and application
* @author 
*/
#ifndef _COMMON_H
#define _COMMON_H

#include <xc.h>
#include <stdint.h>

typedef unsigned char uInt8_t;
typedef unsigned short uInt16_t;
typedef unsigned int uInt32_t;

/* misc parameters */
#define CPU_FREQ_HZ     200000000
#define PB2_FREQ_HZ     100000000
#define TRUE            1
#define FALSE           0
#define ON              1
#define OFF             0
#define HIGH            1
#define LOW             0
#define SET             1
#define CLEAR           0
#define DONT_CARE       0

/* system API reference */

 /**
  * @brief global interrupt enable  
  */
#define sys_interrupt_enable()  asm volatile("ei")

 /**
  * @brief global interrupt disable 
  */
#define sys_interrupt_disable()  asm volatile("di"); \
                                 asm volatile("ehb") 

#endif /*_COMMON_H*/


















