/*
 * led1/src/led1.c
 * led1 driver library
 * author hugo descoubes - copyleft
 */

/* Microchip Harmony dependencies */
#include <sys/attribs.h>
#include <peripheral/peripheral.h>

void led1_init(void){
    PLIB_PORTS_PinClear( PORTS_ID_0, PORT_CHANNEL_H, PORTS_BIT_POS_0 );
    PLIB_PORTS_OpenDrainEnable(PORTS_ID_0, PORT_CHANNEL_H, 0x0);
    PLIB_PORTS_Write( PORTS_ID_0, PORT_CHANNEL_H,  0x0);
    PLIB_PORTS_DirectionOutputSet( PORTS_ID_0, PORT_CHANNEL_H,  0xfff8 ^ 0xFFFF);
    PLIB_PORTS_ChangeNoticePerPortTurnOn(PORTS_ID_0, PORT_CHANNEL_H);
    PLIB_PORTS_ChannelModeSelect(PORTS_ID_0, PORT_CHANNEL_H, 0x70 ^ 0xFFFF, PORTS_PIN_MODE_DIGITAL);
    PLIB_PORTS_ChannelChangeNoticeEnable(PORTS_ID_0, PORT_CHANNEL_H, 0x0);
    PLIB_PORTS_ChannelChangeNoticePullUpEnable(PORTS_ID_0, PORT_CHANNEL_H, 0x0);
    PLIB_PORTS_ChannelChangeNoticePullDownEnable(PORTS_ID_0, PORT_CHANNEL_H, 0x0);
}

void led1_on(void){
    PLIB_PORTS_PinSet( PORTS_ID_0, PORT_CHANNEL_H, PORTS_BIT_POS_0 );
}

void led1_off(void){
    PLIB_PORTS_PinClear( PORTS_ID_0, PORT_CHANNEL_H, PORTS_BIT_POS_0 ); 
}

void led1_toggle(void){
    PLIB_PORTS_PinToggle(PORTS_ID_0, PORT_CHANNEL_H, PORTS_BIT_POS_0 );
}