/*
 * Software system configuration and user application tasks
 */

#include <utask.h>
/* include all user headers dependencies into utask.h file */

#define TEST_AND_DEBUG 0

QueueHandle_t queue_reader_to_writer;
TaskHandle_t xHandle_task_printer;

/* Creation of software system architecture */
void app_init(void)
{ 
	/* tools : sync, protect and com */
    queue_reader_to_writer = xQueueCreate( UART_BUFF_SIZE, sizeof( char ) );

    /* application tasks */
    xTaskCreate(	task_reader,   
				"task_reader",      
				400,     
				NULL, 
				TASK_READER_PRIORITY,
				NULL  );  

    xTaskCreate(	task_printer,   
				"task_printer",      
				400,     
				NULL, 
				TASK_PRINTER_PRIORITY,
				&xHandle_task_printer );  


    xTaskCreate(	task_error,   
				"task_error",      
				400,     
				NULL, 
				TASK_ERROR_PRIORITY,
				NULL ); 
 }

/* Rename task with useful name for a real application */
void task_reader(void *pvParameters)
{
	uInt8_t tmp;
	
	uart_puts("\r\nstart task_reader");
	
    while (1) {
		uart_getc(&tmp, UART_ECHO_OFF);
		xQueueSend( queue_reader_to_writer, &tmp, 0 );		 
    } 
}

/* Rename task with useful name for a real application */
void task_printer(void *pvParameters)
{
	uInt8_t tmp;

	uart_puts("\r\nstart task_printer");	
	uart_puts("\r\neval# ");
	
    while (1) {
		xQueueReceive( queue_reader_to_writer, &tmp, portMAX_DELAY );
		vTaskPrioritySet( NULL, TASK_PRINTER_PRIORITY );
		
		uart_putc(tmp);
		uart_puts("\r\neval# ");		
    }
}

/* Rename task with useful name for a real application */
void task_error(void *pvParameters)
{
	uInt8_t tmp, trash;
	UBaseType_t queue_empty_spaces;
	uInt8_t str_tmp[100];

	uart_puts("\r\nstart task_error");

    while (1) {
		xQueuePeek( queue_reader_to_writer, &tmp, portMAX_DELAY );
	
		#if ( TEST_AND_DEBUG  == 1)
		queue_empty_spaces = uxQueueSpacesAvailable( queue_reader_to_writer );
		sprintf(str_tmp, "%u/", queue_empty_spaces);
		uart_puts(str_tmp);
		#endif
	
		if ( tmp == 'X' ) {
			// empty the queue			
			xQueueReceive( queue_reader_to_writer, &trash, 0 );
			
			#if ( TEST_AND_DEBUG  == 1)
			queue_empty_spaces = uxQueueSpacesAvailable( queue_reader_to_writer );
			sprintf(str_tmp, "%u ", queue_empty_spaces);
			uart_puts(str_tmp);
			#endif
			
			uart_puts("*** X is a forbidden character ***");
			uart_puts("\r\neval# ");		
		} else {
			#if ( TEST_AND_DEBUG  == 1)
			queue_empty_spaces = uxQueueSpacesAvailable( queue_reader_to_writer );
			sprintf(str_tmp, "%u ", queue_empty_spaces);
			uart_puts(str_tmp);
			#endif
		
			// increase temporarily reader task priority to empty the queue
			vTaskPrioritySet( xHandle_task_printer, TASK_ERROR_PRIORITY );
			taskYIELD();		
		}
    }
}
