/*
 * FreeRTOS callback functions for application or system failure
 */

/* Microchip Harmony dependencies */
#include <system/reset/sys_reset.h>
#include <peripheral/peripheral.h>

#include <utask.h>
/* include all user headers dependencies into utask.h file */

/*
* FreeRTOS callback function for stack overflow detection
*/
void vApplicationStackOverflowHook( xTaskHandle xTask, signed char *pcTaskName )
{
    uart_puts("\r\n*** Application error - ");
    uart_puts(pcTaskName);
    uart_puts(" stackoverflow ***");

    /* it's a trap. Comment while(1) to force application software reset */
    while(1);
    PLIB_DEVCON_SystemUnlock(DEVCON_ID_0);
    PLIB_RESET_SoftwareResetEnable(RESET_ID_0);
}

/*
* FreeRTOS callback function for heap overflow detection
*/
void vApplicationMallocFailedHook( void )
{
    uart_puts("\r\n*** Application error - heap overflow ***");

    /* it's a trap. Comment while(1) to force application software reset */
    while(1);
    PLIB_DEVCON_SystemUnlock(DEVCON_ID_0);
    PLIB_RESET_SoftwareResetEnable(RESET_ID_0);
}

/*
* FreeRTOS callback function for kernel assertion
*/
void vAssertCalled( const char *pcFileName, unsigned long ulLine )
{
    uart_puts("\r\n*** Application error - kernel assertion ***");

    /* it's a trap. Comment while(1) to force application software reset */
    while(1);
    PLIB_DEVCON_SystemUnlock(DEVCON_ID_0);
    PLIB_RESET_SoftwareResetEnable(RESET_ID_0);
}