/**
* @file include/utask.h
* @brief User application header
* @author 
*/

#ifndef   __HEADER_USER_TASK__
#define   __HEADER_USER_TASK__

#include <stdio.h>
#include <kuart/include/kuart.h>
#include <FreeRTOS.h>
#include <task.h>
#include <queue.h>
#include <semphr.h>
/* Add FreeRTOS dependencies */

#define TASK_READER_PRIORITY 2
#define TASK_PRINTER_PRIORITY 1
#define TASK_ERROR_PRIORITY 3

/* Application API reference */

/**
* @fn void app_init(void)
* @brief Creation of software system architecture
*/
void app_init(void);

/**
* @fn  void task_reader(void *pvParameters)
* @brief Rename task with useful name for a real application
*/
void task_reader(void *pvParameters);

/**
* @fn  void task_printer(void *pvParameters)
* @brief Rename task with useful name for a real application
*/
void task_printer(void *pvParameters);

/**
* @fn  void task3(void *pvParameters)
* @brief Rename task with useful name for a real application
*/
void task_error(void *pvParameters);

#endif 
