/*
 * test program for uart library
 */

/* Microchip Harmony dependencies */
#include <system/reset/sys_reset.h>
#include <peripheral/peripheral.h>

#include <bsplib.h>
#include <utask.h>
/* include all user headers dependencies into utask.h file */

void main(void)
{
    uInt8_t str_tmp[100];
     
    /* Hardware system init*/
    uart_init(UART_BAUD_RATE);
 
	/* Software system init */
	app_init();
	
    /* Start application */
    sprintf(str_tmp, "\r\nStart eval demo application - %s %s", __DATE__, __TIME__);
    uart_puts(str_tmp);
    uart_puts("\n\rGood luck, push the limits !");
    
	vTaskStartScheduler();
	
	/* It's a trap */
    while (1);    
}

/* General processor exception */
void _general_exception_handler ( void )
{
    uart_puts("\r\n*** General processor exception ***");

    /* it's a trap. Comment while(1) to force application software reset */
    while(1);
    PLIB_DEVCON_SystemUnlock(DEVCON_ID_0);
    PLIB_RESET_SoftwareResetEnable(RESET_ID_0);
}

