/*
* file idmalib/src/edmacpy.c
* brief EDMA (Enhanced Direct Memory Access) bytes copy
* from array source to destination array
* author hugo descoubes
* date
*/

#include "edmalib.h"


void edmacpy(	void *dst, 			\
				void *src,			\
				Uint32 nbBytes){

	Int32							instNum    = 0;
	Uint8							channelNum = 0;
	CSL_Edma3Handle                 hModule;
	CSL_Edma3Obj                    edmaObj;
	CSL_Edma3ParamHandle            hParam;
	CSL_Edma3ChannelObj             chObj;
	CSL_Edma3CmdIntr                regionIntr;
	CSL_Edma3ChannelHandle          hChannel;
	CSL_Edma3ParamSetup             myParamSetup;
	CSL_Edma3Context                context;
	CSL_Edma3ChannelAttr            chAttr;
	CSL_Status                      status;

	/* module initialization */
	CSL_edma3Init(&context);

	/* open the EDMA Module using the provided instance number */
	hModule = CSL_edma3Open(&edmaObj, instNum, NULL, &status);

	/* check for channel opening */
	chAttr.regionNum = CSL_EDMA3_REGION_GLOBAL;
	chAttr.chaNum    = channelNum;
	hChannel = CSL_edma3ChannelOpen(&chObj, instNum, &chAttr, &status);

	/* queue bypass */
	CSL_edma3HwChannelSetupQue(hChannel,CSL_EDMA3_QUE_1);

	/* map the DMA Channel to PARAM Block 2 */
	CSL_edma3MapDMAChannelToParamBlock (hModule, channelNum, 2);

	/* obtain a handle object of parameter set 2 */
	hParam = CSL_edma3GetParamHandle(hChannel, 2, &status);

	/* channel configuration :
	 * chaining disable
	 * transfer interupt enable
	 */
	myParamSetup.option = CSL_EDMA3_OPT_MAKE(
			CSL_EDMA3_ITCCH_DIS,      		\
			CSL_EDMA3_TCCH_DIS,       		\
			CSL_EDMA3_ITCINT_DIS,     		\
			CSL_EDMA3_TCINT_EN,       		\
			0, CSL_EDMA3_TCC_NORMAL,  		\
			CSL_EDMA3_FIFOWIDTH_64BIT, 		\
			CSL_EDMA3_STATIC_DIS,     		\
			CSL_EDMA3_SYNC_A,         		\
			CSL_EDMA3_ADDRMODE_INCR,  		\
			CSL_EDMA3_ADDRMODE_INCR );
	myParamSetup.srcAddr    = (Uint32) src;
	myParamSetup.aCntbCnt   = CSL_EDMA3_CNT_MAKE(nbBytes,1);
	myParamSetup.dstAddr    = (Uint32) dst;
	//myParamSetup.srcDstBidx = CSL_EDMA3_BIDX_MAKE(1,1);
	//myParamSetup.srcDstCidx = CSL_EDMA3_CIDX_MAKE(0,1);
	myParamSetup.cCnt = 1;

	/* apply configuration to selected channel */
	CSL_edma3ParamSetup(hParam,&myParamSetup);

	/* interrupt enable (Bits 0-1)  for the global region interrupts */
	regionIntr.region = CSL_EDMA3_REGION_GLOBAL;
	regionIntr.intr   = 0x3;
	regionIntr.intrh  = 0x0000;
	CSL_edma3HwControl(hModule,CSL_EDMA3_CMD_INTR_ENABLE,&regionIntr);

	/* trigger channel transfer */
	CSL_edma3HwChannelControl(hChannel,CSL_EDMA3_CMD_CHANNEL_SET,NULL);
	regionIntr.region = CSL_EDMA3_REGION_GLOBAL;
	regionIntr.intr   = 0;
	regionIntr.intrh  = 0;

	/* wait the end of transmission */
	do {
		CSL_edma3GetHwStatus(hModule,CSL_EDMA3_QUERY_INTRPEND,&regionIntr);
	} while (!(regionIntr.intr & 0x1));

	/* clear the pending bit */
	CSL_edma3HwControl(hModule,CSL_EDMA3_CMD_INTRPEND_CLEAR,&regionIntr);

	/* close channel */
	CSL_edma3ChannelClose(hChannel);

	/* close EDMA module */
	CSL_edma3Close(hModule);
}
