/*
* file firlib\src\fir_sp_r14.c
* brief FIR filtering function in canonical C radix 4 (single precision IEEE754)
* author
* date
*/

#include "firlib.h"

void fir_sp_r14 (	const float * restrict xk, 	\
					const float * restrict a,	\
					float * restrict yk, 		\
					int na,						\
					int nyk){
	int i, j;
	float xk0, xk1, xk2, xk3;
	float a0, a1, a2, a3;
	float acc0, acc1, acc2, acc3;
	
	/* input array loop */
	for (i=0; i<nyk; i++) {
		acc0 = 0.0;
		acc1 = 0.0;
		acc2 = 0.0;
		acc3 = 0.0;
		
		/* FIR filter algorithm - dot product */
		for (j=0; j<na; j+=4){
			a0 = a[j];
			a1 = a[j+1];
			a2 = a[j+2];
			a3 = a[j+3];
			
			xk0 = xk[j+i];
			xk1 = xk[j+i+1];
			xk2 = xk[j+i+2];
			xk3 = xk[j+i+3];
			
			acc0 += a0*xk0;
			acc1 += a1*xk1;
			acc2 += a2*xk2;
			acc3 += a3*xk3;
		}
		
		yk[i] = acc0 + acc1 + acc2 + acc3;
	}
}
