#ifndef __EDMA_LIB_H
#define __EDMA_LIB_H

/**
* @file edmalib\h\edmalib.h
* @brief EDMA (Enhanced Direct Memory Access) bytes copy
* from array source to destination array
* @author
* @date
*/

#include <ti/csl/csl_edma3.h>
#include <ti/csl/csl_edma3Aux.h>

/**
 * @brief EDMA (Enhanced Direct Memory Access) bytes copy
 * from array source to destination array
 * @param dst pointer on destination array
 * @param src pointer on source array
 * @param nbBytes number of bytes to copy
 */
void edmacpy(	void *dst, 			\
				void *src,			\
				Uint32 nbBytes);

#endif /* __EDMA_LIB_H */
