#ifndef __IDMA_LIB_H
#define __IDMA_LIB_H

/**
* @file idmalib\h\idmalib.h
* @brief IDMA (CorePac Internal Direct Memory Access) bytes copy
*  from array source to destination array in Level 1 memory model
* @author hugo descoubes
* @date 12 october 2015
*/

#include <ti/csl/csl_idma.h>
#include <ti/csl/csl_idmaAux.h>

/**
 * @brief IDMA (CorePac Internal Direct Memory Access) bytes copy
*  from L2 array source to destination array in L1D memory
 * @param dst pointer of destination array
 * @param src pointer of source array
 * @param nbBytes number of bytes to copy
 */
void idmacpy(	void *dst, 			\
				void *src,			\
				Uint16 nbBytes);


#endif /* __IDMA_LIB_H */
