/*
* file test/src/firtest_perf.c
* brief performance test for FIR algorithms library
* author hugo descoubes
* date mixing 09/2012 and 09/2021
*/


#include <firtest.h>


void firtest_perf(	TestPerf_obj *benchmark,
					uint8_t memoryModel,
					float * restrict output,
					void (*fir_fct) (	const float * restrict,
										const float * restrict,
										float * restrict,
										int,
										int) ) 
{
	volatile CSL_Uint64 start, end, duration=0;
	volatile uint32_t k, rep;

	for (k=0; k < YK_LENGTH; k++) {
		output[k] = 0.0;
	}

	rep = benchmark->perf_rep;

	/* fix number of algorithm repetitions for average calculation */
	for (k=0; k < rep; k++) {

		/* read current TSC core timer value */
		start = CSL_tscRead ();

		/* indirect call of the needed fir algorithm */
		(*fir_fct) (xk_sp, a_sp, output, A_LENGTH, YK_LENGTH);

		/* processing time duration */
		end = CSL_tscRead ();
		duration += end-start;
	}

	/* back up measurements */
	duration /= benchmark->perf_rep;
	benchmark->perf_nbcycles = duration;
	benchmark->perf_usertime_ms = (float32_t) duration * CPU_CLOCK_MS;
	benchmark->perf_macs = ((float32_t) FIR_NB_MACS) / ((float32_t) duration);
}

