/*
* rl01/src/rl01_write.c
* 
*/

#include <i2c1/include/i2c1.h>
#include <rl01.h>

uInt8_t rl01_write(uInt8_t cmd, uInt8_t payload)
{
    uInt8_t add_w = 0x00;
    
    add_w = (uInt8_t) (SC18IS602B_ADD << 1);
    
    /* start */
    i2c1_idle();
    i2c1_start();
    
    /* send address and write sequence */
    i2c1_send(add_w);
    i2c1_idle();   
 
    /* send data sequence */
    if ( i2c1_ack() )  {
        i2c1_send(cmd);
        i2c1_idle();
    } else {
        goto fail_add_ack;
    }

    /* send data sequence */
    if ( i2c1_ack() )  {
        i2c1_send(payload);
        i2c1_idle();
    } else {
        goto fail_data_ack;
    }
    
    /* stop */
    if ( i2c1_ack() )  {
        i2c1_stop();
    } else {
        goto fail_data_ack;
    }
    
    return TRUE;
fail_add_ack:
fail_data_ack:
    return FALSE; 
}

