/*
* rl01/src/rl01_read.c
* 
*/

#include <i2c1/include/i2c1.h>
#include <rl01.h>

uInt8_t rl01_read( uInt8_t *payload )
{
    uInt8_t add_r = 0x00;
    
    add_r = (uInt8_t) (SC18IS602B_ADD << 1);
    add_r |= 0x01;
    
     /* start */
    i2c1_idle();
    i2c1_start();
    
    /* send address and read sequence */
    i2c1_send( add_r );
    i2c1_idle();
    
    /* receive data */
    if ( i2c1_ack() ) {
        i2c1_receive( *payload );
        i2c1_master_nack();
        i2c1_idle();
    } else {
        goto fail_add_ack;
    }

    /* stop */
    i2c1_stop();
    
    return TRUE; 
fail_add_ack:
fail_data_ack:
    return FALSE; 
}

