/*
* htu21d/src/read_measurement.c
* read measurement (temperature or relative humidity)
*/

#include <i2c1/include/i2c1.h>
#include <common/include/delay.h>
#include <htu21d.h>

uInt8_t read_measurement( uInt8_t add, uInt8_t cmd, uInt16_t *payload, uInt8_t *checksum )
{
    /* read measurement frame :
     *         |                     |             |        |         
     * [start] | [address] [w] [ack] | [cmd] [ack] | [stop] |
     *    1    |     7      1    1   |   8     1   |    1   |
     *         |                     |                   |                   |                    |
     * [start] | [address] [r] [ack] | [data(MSB)] [ack] | [data(LSB)] [ack] | [checksum)] [nack] | [stop]
     *    1    |     7      1    1   |      8        1   |      8        1   |      8         1   |    1
     */
    
    uInt8_t add_w = 0x00;
    uInt8_t add_r = 0x00;
    
    add_w = (uInt8_t) (add << 1);
    add_r = (uInt8_t) (add << 1);
    add_r |= 0x01;
    
    uInt8_t payload_1 = 0x00;
    uInt8_t payload_2 = 0x00;
    uInt16_t payload_tmp = 0x0000;
    
     /* start */
    i2c1_idle();
    i2c1_start();
    
    /* send address and write sequence */
    i2c1_send( add_w );
    i2c1_idle();
    
    /* send command */
    if ( i2c1_ack() ) {
        i2c1_send( cmd );
        i2c1_idle();
    } else {
        goto fail_add_ack;
    }
    
    /* stop */
    if ( i2c1_ack() ) {
        i2c1_stop();
    } else {
        goto fail_data_ack;
    }
    
    delay_10us();
    
    /* start */
    i2c1_idle();
    i2c1_start();
    
    /* send address and read sequence */
    i2c1_send( add_r );
    i2c1_idle();
    
    /* receive data (MSB) */
    if ( i2c1_ack() ) {
        i2c1_receive( payload_1 );
        i2c1_master_ack();
        i2c1_idle();
    } else {
        goto fail_add_ack;
    }
    
    /* receive data (LSB) */
    i2c1_receive( payload_2 );
    i2c1_master_ack();
    i2c1_idle();
    
    /* receive checksum */
    i2c1_receive( *checksum );
    i2c1_master_nack();
    i2c1_idle();
    
    /* stop */
    i2c1_stop();
    
    payload_tmp = (( payload_1 << 8 ) | payload_2);
    *payload = payload_tmp;
    
    return TRUE; 
fail_add_ack:
fail_data_ack:
    return FALSE;   
}

