#include <RH_RF95.h>

#define LED_BUILTIN 16

#define CR02_FREQUENCY 868.0

#define TRUE  1
#define FALSE 0

#define DEBUG_CONSOLE 0

uint8_t payload;
uint8_t payload_msb;
uint8_t payload_lsb;
uint8_t len = sizeof(payload);

uint8_t is_msb = TRUE;
uint8_t nb_byte = 0;

char buf[50];
uint8_t status_measurement;
uint16_t data;
float physical_value;

/*
  Slave Select mapped to D13/PD2
  Interrupt mapped to D14/PB2
*/
RH_RF95 CR02;

void setup()
{
  pinMode(LED_BUILTIN, OUTPUT);

  Serial.begin(9600, SERIAL_8N1);   // start serial for output

  if (!CR02.init()) {
#if DEBUG_CONSOLE
    Serial.println("init failed");
#endif
  }
  
  // The default transmitter power is 13dBm, using PA_BOOST.
  // If you are using RFM95/96/97/98 modules which uses the PA_BOOST transmitter pin, then
  // you can set transmitter powers from 5 to 23 dBm:
  // Failure to do that will result in extremely low transmit powers.

  //CR02.setModemConfig(CR02.Bw31_25Cr48Sf512);
  CR02.setFrequency(CR02_FREQUENCY);
  CR02.setTxPower(23, false);
}

void loop()
{ 
  if (CR02.available()) {
    
    if (CR02.recv(&payload, &len)) {
      
      digitalWrite(LED_BUILTIN, HIGH);
      
      if (is_msb) {
        payload_msb = payload;
        is_msb = FALSE;
        nb_byte ++;
      } else {
        payload_lsb = payload;
        is_msb = TRUE;
        nb_byte ++;
      }
      
      digitalWrite(LED_BUILTIN, LOW);
      
    } else {
#if DEBUG_CONSOLE
      Serial.println("recv failed");
#endif
    }

    if (nb_byte == 2) {
      
#if DEBUG_CONSOLE
      data = payload_msb << 8;
      data |= payload_lsb;

      Serial.println("\n~cr02_receiver~");
      Serial.println("Sending to serial ...");
      Serial.print("0x");
      Serial.print(payload_msb, HEX);
      Serial.print(payload_lsb, HEX);
    
      status_measurement = payload_lsb & 0x02;
      if (status_measurement == 0x02) {
        data &= 0xfffc;
        physical_value = ( ( data * 125.0 ) / 65536 ) - 6;
        Serial.print(" -> Relative humidity : ");
        sprintf(buf,
                "%d.%02u",
                (uint8_t) physical_value,
                (uint8_t) ((physical_value - (uint8_t) physical_value ) * 100));
        Serial.print(buf);
        Serial.println(" %"); 
      }
      if (status_measurement == 0x00) {
        physical_value = ( (data * 175.72 ) /65536 ) - 46.85;
        Serial.print(" -> Temperature : ");
        sprintf(buf,
                "%d.%02u",
                (uint8_t) physical_value,
                (uint8_t) ((physical_value - (uint8_t) physical_value ) * 100));
        Serial.print(buf);
        Serial.println(" °C");
      }
#endif

#if !DEBUG_CONSOLE
      Serial.write(payload_lsb);
      Serial.write(payload_msb);
#endif

      nb_byte = 0;
      
    }
  }
}
