#!/usr/bin/env python3
# 20/01/2022
# Publish data with mqtt to a ThingSpeak server
# OPEN-SOURCE

import paho.mqtt.publish as publish
import paho.mqtt.client as mqtt
import string
import socket
import time

##############
# on_message #
##############
def on_message(client,userdata, msg):
    message_received=str(msg.payload.decode("utf-8"))
    channel_ID = "1635758"
    t_port = 80
    t_transport="websockets"
    mqtt_host = "mqtt3.thingspeak.com"
    mqtt_client_ID = "ORYNAwQDASUICCE9IAotHi8"
    mqtt_username  = "ORYNAwQDASUICCE9IAotHi8"
    mqtt_password  = "Uew5ZBCRq0jae84GAbjrN/ad"
    topic_ = "channels/" + channel_ID + "/publish"
    data_type=message_received.split(" :")[0]
    data=message_received.split(": ")[1]
    if(data_type == "Relative humidity"):
        payload="field1="+data
    elif(data_type == "Temperature"):
        payload="field2="+data

    try:
       print("\n~Raspberry Pi~")
       print("Sending to ThingSpeak ...")
       print(data_type, " : ", data, "\n")
       publish.single(topic_, payload, hostname=mqtt_host, transport=t_transport,
                      port=t_port, client_id=mqtt_client_ID, auth={'username':mqtt_username,'password':mqtt_password})
    except Exception as e:
        print (e)


if __name__ == '__main__':
    topic = "Measurements"
    client = mqtt.Client("test")
    client.on_message = on_message
    client.connect("localhost",1883,60)
    client.subscribe(topic)

    try:
       client.loop_forever()
    except KeyboardInterrupt:
        client.disconnect()
        client.loop_stop()
