/******************************************************************************
 * Generic driver for NXP NCI NFC chips : fw.c
 ******************************************************************************/
... some include and defines 

void nxp_nci_fw_work_complete(struct nxp_nci_info *info, int result)
{
	struct nxp_nci_fw_info *fw_info = &info->fw_info; 	int r;
	result = info->phy_ops->set_mode(info->phy_id, NXP_NCI_MODE_COLD);
	info->mode = NXP_NCI_MODE_COLD;
	nfc_fw_download_done(info->ndev->nfc_dev, fw_info->name, result);
}

static int nxp_nci_fw_send_chunk(struct nxp_nci_info *info)
{
	struct sk_buff *skb; struct nxp_nci_fw_info *fw_info = &info->fw_info;
	size_t chunk_len,remaining_len; u16 header, crc;

	... some code to compute header, chunk_len, remaining_len, crc
	skb = nci_skb_alloc(info->ndev, info->max_payload, GFP_KERNEL);
	skb_put_data(skb, fw_info->data + fw_info->written, chunk_len);
	r = info->phy_ops->write(info->phy_id, skb);
	kfree_skb(skb);
	return r;
}

static int nxp_nci_fw_send(struct nxp_nci_info *info)
{
	struct nxp_nci_fw_info *fw_info = &info->fw_info;
	long completion_rc;

	reinit_completion(&fw_info->cmd_completion);

	if (fw_info->written == 0) {
		fw_info->frame_size = get_unaligned_be16(fw_info->data);
		fw_info->data += NXP_NCI_FW_HDR_LEN;
		fw_info->size -= NXP_NCI_FW_HDR_LEN;
	}
	fw_info->written += nxp_nci_fw_send_chunk(info);

	if (*fw_info->data == NXP_NCI_FW_CMD_RESET) {
		fw_info->cmd_result = 0;
		if (fw_info->fw)
			schedule_work(&fw_info->work);
	} else {
		completion_rc = wait_for_completion_interruptible_timeout(
			&fw_info->cmd_completion, NXP_NCI_FW_ANSWER_TIMEOUT);
		if (completion_rc == 0)
			return -ETIMEDOUT;
	}
	return 0;
}

void nxp_nci_fw_work(struct work_struct *work)
{
	struct nxp_nci_info *info; struct nxp_nci_fw_info *fw_info;

	fw_info = container_of(work, struct nxp_nci_fw_info, work);
	info = container_of(fw_info, struct nxp_nci_info, fw_info);
	mutex_lock(&info->info_lock);
	fw_info->cmd_result;
	if (fw_info->written == fw_info->frame_size) {
		fw_info->data += fw_info->frame_size;
		fw_info->size -= fw_info->frame_size;
		fw_info->written = 0;
	}
	if (fw_info->size > 0)
		r = nxp_nci_fw_send(info);
	else
		nxp_nci_fw_work_complete(info, r);
	mutex_unlock(&info->info_lock);
}

void nxp_nci_fw_download(struct nci_dev *ndev, const char *firmware_name)
{
	struct nxp_nci_info *info = nci_get_drvdata(ndev);
	struct nxp_nci_fw_info *fw_info = &info->fw_info;

	mutex_lock(&info->info_lock);
	strcpy(fw_info->name, firmware_name);
	request_firmware(&fw_info->fw, firmware_name, ndev->nfc_dev->dev.parent);
	r = info->phy_ops->set_mode(info->phy_id, NXP_NCI_MODE_FW);
	info->mode = NXP_NCI_MODE_FW;
	fw_info->data = fw_info->fw->data;
	fw_info->size = fw_info->fw->size;
	fw_info->written = 0;
	fw_info->frame_size = 0;
	fw_info->cmd_result = 0;
	schedule_work(&fw_info->work);
	mutex_unlock(&info->info_lock);
}

void nxp_nci_fw_recv_frame(struct nci_dev *ndev, struct sk_buff *skb)
{
	struct nxp_nci_info *info = nci_get_drvdata(ndev);
	struct nxp_nci_fw_info *fw_info = &info->fw_info;

	complete(&fw_info->cmd_completion);
	if (skb) {
		fw_info->cmd_result = nxp_nci_fw_read_status(*(u8 *)skb_pull(skb, HDR_LEN));
		kfree_skb(skb);
	} else {
		fw_info->cmd_result = -EIO;
	}
	schedule_work(&fw_info->work);
}
EXPORT_SYMBOL(nxp_nci_fw_recv_frame);
