#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define ARRAY_SIZE      1e6


/**
 * Work on a small part of the array
 * Using few instructions in the loop
 */
int main(void)
{
    unsigned long int* array = (unsigned long int*) malloc( ARRAY_SIZE * sizeof(unsigned long int) );
    unsigned long int idx;

    clock_t start, end;
    
    start = clock();    
    
    for( unsigned long int i = 0; i < ARRAY_SIZE ; i++ )
    {
        idx = i % 10;		// Modulo to keep working on the first elements of the array
        array[idx] = i;
    }
    
    end = clock();
    
    printf("Version 1 = %f s\n", ((double)(end-start)) / CLOCKS_PER_SEC );
    
    free(array);

    return 0;
}
